/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.panes;

import com.google.common.collect.Maps;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.ftb.data.LauncherStyle;
import net.ftb.data.ModPack;
import net.ftb.data.TexturePack;
import net.ftb.data.events.TexturePackListener;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.dialogs.SearchDialog;
import net.ftb.gui.dialogs.TexturePackFilterDialog;
import net.ftb.gui.panes.ILauncherPane;
import net.ftb.locale.I18N;
import net.ftb.log.Logger;
import net.ftb.util.OSUtils;

public class TexturepackPane
extends JPanel
implements ILauncherPane,
TexturePackListener {
    private static JPanel texturePacks;
    public static ArrayList<JPanel> texturePackPanels;
    private static JScrollPane texturePacksScroll;
    private JButton mapButton;
    private JButton textureButton;
    private static JLabel typeLbl;
    public static String compatible;
    public static String resolution;
    private JButton filter;
    private static boolean texturePacksAdded;
    private static int selectedTexturePack;
    private static JEditorPane textureInfo;
    private static TexturepackPane instance;
    private static HashMap<Integer, TexturePack> currentTexturePacks;
    public static boolean loaded;

    public TexturepackPane() {
        instance = this;
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(null);
        texturePackPanels = new ArrayList();
        texturePacks = new JPanel();
        texturePacks.setLayout(null);
        texturePacks.setOpaque(false);
        JPanel p = new JPanel();
        p.setBounds(0, 0, 420, 55);
        p.setLayout(null);
        this.filter = new JButton(I18N.getLocaleString("FILTER_SETTINGS"));
        this.filter.setBounds(5, 5, 105, 25);
        this.filter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TexturePackFilterDialog filter = new TexturePackFilterDialog(instance);
                filter.setVisible(true);
            }
        });
        this.add(this.filter);
        String filterTextColor = LauncherStyle.getColorAsString(LauncherStyle.getCurrentStyle().filterTextColor);
        String filterInnerTextColor = LauncherStyle.getColorAsString(LauncherStyle.getCurrentStyle().filterInnerTextColor);
        String typeLblText = "<html><body>";
        typeLblText = typeLblText + "<strong><font color=rgb\"(" + filterTextColor + ")\">Filter: </strong></font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + compatible + "</font>";
        typeLblText = typeLblText + "<strong><font color=rgb\"(" + filterTextColor + ")\"> / </strong></font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + resolution + "</font>";
        typeLblText = typeLblText + "</body></html>";
        this.mapButton = new JButton(I18N.getLocaleString("SWAP_MAP"));
        this.mapButton.setBounds(400, 5, 105, 25);
        this.mapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LaunchFrame.getInstance().swapTabs(true);
            }
        });
        this.add(this.mapButton);
        this.textureButton = new JButton(I18N.getLocaleString("SWAP_TEXTURE"));
        this.textureButton.setBounds(510, 5, 105, 25);
        this.textureButton.setBackground(UIManager.getColor("control").darker().darker());
        this.textureButton.setForeground(UIManager.getColor("text").darker());
        this.textureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LaunchFrame.getInstance().swapTabs(false);
            }
        });
        this.add(this.textureButton);
        typeLbl = new JLabel(typeLblText);
        typeLbl.setBounds(115, 5, 295, 25);
        typeLbl.setHorizontalAlignment(0);
        this.add(typeLbl);
        JTextArea filler = new JTextArea(I18N.getLocaleString("TEXTURE_WAIT_WHILE_LOADING"));
        filler.setBorder(null);
        filler.setEditable(false);
        filler.setForeground(LauncherStyle.getCurrentStyle().tabPaneForeground);
        filler.setBounds(58, 6, 378, 42);
        filler.setBackground(LauncherStyle.getCurrentStyle().tabPaneBackground);
        p.add(filler);
        texturePacks.add(p);
        texturePacksScroll = new JScrollPane();
        texturePacksScroll.setBounds(-3, 30, 420, 283);
        texturePacksScroll.setHorizontalScrollBarPolicy(31);
        texturePacksScroll.setVerticalScrollBarPolicy(22);
        texturePacksScroll.setWheelScrollingEnabled(true);
        texturePacksScroll.setOpaque(false);
        texturePacksScroll.setViewportView(texturePacks);
        texturePacksScroll.getVerticalScrollBar().setUnitIncrement(19);
        this.add(texturePacksScroll);
        textureInfo = new JEditorPane();
        textureInfo.setEditable(false);
        textureInfo.setContentType("text/html");
        textureInfo.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    OSUtils.browse(event.getURL().toString());
                }
            }
        });
        textureInfo.setBounds(420, 210, 410, 90);
        textureInfo.setBackground(UIManager.getColor("control").darker().darker());
        this.add(textureInfo);
        JScrollPane infoScroll = new JScrollPane();
        infoScroll.setBounds(410, 25, 430, 290);
        infoScroll.setHorizontalScrollBarPolicy(31);
        infoScroll.setVerticalScrollBarPolicy(20);
        infoScroll.setWheelScrollingEnabled(true);
        infoScroll.setViewportView(textureInfo);
        infoScroll.setOpaque(false);
        this.add(infoScroll);
    }

    @Override
    public void onVisible() {
        TexturepackPane.updateFilter();
        TexturepackPane.getInstance();
        TexturepackPane.getTexturePacksScroll().getViewport().setViewPosition(new Point(0, 0));
    }

    public static void addTexturePack(TexturePack texturePack) {
        if (!texturePacksAdded) {
            texturePacksAdded = true;
            texturePacks.removeAll();
        }
        final int texturePackIndex = texturePackPanels.size();
        JPanel p = new JPanel();
        p.setBounds(0, texturePackIndex * 55, 420, 55);
        p.setLayout(null);
        JLabel logo = new JLabel(new ImageIcon(texturePack.getLogo()));
        logo.setBounds(6, 6, 42, 42);
        logo.setVisible(true);
        String info = texturePack.getInfo().length() > 60 ? texturePack.getInfo().substring(0, 59) + "..." : texturePack.getInfo();
        JTextArea filler = new JTextArea(texturePack.getName() + " : " + texturePack.getAuthor() + "\n" + info);
        filler.setBorder(null);
        filler.setEditable(false);
        filler.setForeground(LauncherStyle.getCurrentStyle().tabPaneForeground);
        filler.setBounds(58, 6, 378, 42);
        filler.setBackground(LauncherStyle.getCurrentStyle().tabPaneBackground);
        MouseAdapter lin = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                selectedTexturePack = texturePackIndex;
                TexturepackPane.updateTexturePacks();
            }
        };
        p.addMouseListener(lin);
        filler.addMouseListener(lin);
        logo.addMouseListener(lin);
        p.add(filler);
        p.add(logo);
        texturePackPanels.add(p);
        texturePacks.add(p);
        if (compatible.equalsIgnoreCase("all") && resolution.equalsIgnoreCase("all")) {
            texturePacks.setMinimumSize(new Dimension(420, TexturePack.getTexturePackArray().size() * 55));
            texturePacks.setPreferredSize(new Dimension(420, TexturePack.getTexturePackArray().size() * 55));
        } else {
            texturePacks.setMinimumSize(new Dimension(420, currentTexturePacks.size() * 55));
            texturePacks.setPreferredSize(new Dimension(420, currentTexturePacks.size() * 55));
        }
        texturePacksScroll.revalidate();
    }

    @Override
    public void onTexturePackAdded(TexturePack texturePack) {
        final TexturePack texturePack_ = texturePack;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TexturepackPane.addTexturePack(texturePack_);
                Logger.logInfo("Adding texture pack " + TexturepackPane.getTexturePackNum() + " (" + texturePack_.getName() + ")");
                TexturepackPane.updateTexturePacks();
            }
        });
    }

    public static void sortTexturePacks() {
        texturePackPanels.clear();
        texturePacks.removeAll();
        currentTexturePacks.clear();
        int counter = 0;
        selectedTexturePack = 0;
        texturePacks.repaint();
        HashMap sorted = Maps.newHashMap();
        sorted.put(0, new ArrayList());
        sorted.put(1, new ArrayList());
        for (TexturePack texturePack : TexturePack.getTexturePackArray()) {
            if (!TexturepackPane.compatibilityCheck(texturePack) || !TexturepackPane.resolutionCheck(texturePack) || !TexturepackPane.textSearch(texturePack)) continue;
            if (texturePack.isCompatible(ModPack.getSelectedPack(true).getName())) {
                ((List)sorted.get(1)).add(texturePack);
                continue;
            }
            if (texturePack.isCompatible(ModPack.getSelectedPack(false).getName())) {
                ((List)sorted.get(1)).add(texturePack);
                continue;
            }
            ((List)sorted.get(0)).add(texturePack);
        }
        for (TexturePack tp : (List)sorted.get(1)) {
            TexturepackPane.addTexturePack(tp);
            currentTexturePacks.put(counter, tp);
            ++counter;
        }
        for (TexturePack tp : (List)sorted.get(0)) {
            TexturepackPane.addTexturePack(tp);
            currentTexturePacks.put(counter, tp);
            ++counter;
        }
        TexturepackPane.updateTexturePacks();
    }

    private static void updateTexturePacks() {
        for (int i = 0; i < texturePackPanels.size(); ++i) {
            if (selectedTexturePack == i) {
                String packs = "";
                if (TexturePack.getTexturePack(TexturepackPane.getIndex()).getCompatible() != null) {
                    packs = packs + "<p>This texture pack works with the following packs:</p><ul>";
                    for (String name : TexturePack.getTexturePack(TexturepackPane.getIndex()).getCompatible()) {
                        packs = packs + "<li>" + (ModPack.getPack(name) != null ? ModPack.getPack(name).getName() : name) + "</li>";
                    }
                    packs = packs + "</ul>";
                }
                texturePackPanels.get(i).setBackground(UIManager.getColor("control").darker().darker());
                texturePackPanels.get(i).setCursor(Cursor.getPredefinedCursor(0));
                LaunchFrame.updateTpInstallLocs(TexturePack.getTexturePack(TexturepackPane.getIndex()).getCompatible());
                File tempDir = new File(OSUtils.getCacheStorageLocation(), "TexturePacks" + File.separator + TexturePack.getTexturePack(TexturepackPane.getIndex()).getName());
                textureInfo.setText("<html><img src='file:///" + tempDir.getPath() + File.separator + TexturePack.getTexturePack(TexturepackPane.getIndex()).getImageName() + "' width=400 height=200></img> <br>" + TexturePack.getTexturePack(TexturepackPane.getIndex()).getInfo() + packs);
                textureInfo.setCaretPosition(0);
                continue;
            }
            texturePackPanels.get(i).setBackground(UIManager.getColor("control"));
            texturePackPanels.get(i).setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public static int getSelectedTexturePackIndex() {
        return texturePacksAdded ? TexturepackPane.getIndex() : -1;
    }

    public static void updateFilter() {
        String filterTextColor = LauncherStyle.getColorAsString(LauncherStyle.getCurrentStyle().filterTextColor);
        String filterInnerTextColor = LauncherStyle.getColorAsString(LauncherStyle.getCurrentStyle().filterInnerTextColor);
        String typeLblText = "<html><body>";
        typeLblText = typeLblText + "<strong><font color=rgb\"(" + filterTextColor + ")\">Filter: </strong></font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + compatible + "</font>";
        typeLblText = typeLblText + "<strong><font color=rgb\"(" + filterTextColor + ")\"> / </strong></font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + resolution + "</font>";
        typeLblText = typeLblText + "</body></html>";
        typeLbl.setText(typeLblText);
        TexturepackPane.sortTexturePacks();
        LaunchFrame.getInstance().updateFooter();
    }

    private static int getIndex() {
        return currentTexturePacks.size() > 0 ? currentTexturePacks.get(selectedTexturePack).getIndex() : selectedTexturePack;
    }

    private static int getTexturePackNum() {
        if (!(currentTexturePacks.size() <= 0 || compatible.equalsIgnoreCase(I18N.getLocaleString("MAIN_ALL")) && resolution.equalsIgnoreCase(I18N.getLocaleString("MAIN_ALL")))) {
            return currentTexturePacks.get(texturePackPanels.size() - 1).getIndex();
        }
        return texturePackPanels.size();
    }

    public void updateLocale() {
        this.filter.setText(I18N.getLocaleString("FILTER_SETTINGS"));
    }

    private static boolean compatibilityCheck(TexturePack tp) {
        return compatible.equalsIgnoreCase(I18N.getLocaleString("MAIN_ALL")) || tp.isCompatible(compatible);
    }

    private static boolean resolutionCheck(TexturePack tp) {
        return resolution.equalsIgnoreCase(I18N.getLocaleString("MAIN_ALL")) || tp.getResolution().equalsIgnoreCase(resolution);
    }

    private static boolean textSearch(TexturePack tp) {
        String searchString = SearchDialog.lastTextureSearch.toLowerCase();
        return searchString.isEmpty() || tp.getName().toLowerCase().contains(searchString) || tp.getAuthor().toLowerCase().contains(searchString);
    }

    public static JScrollPane getTexturePacksScroll() {
        return texturePacksScroll;
    }

    public static TexturepackPane getInstance() {
        return instance;
    }

    static {
        compatible = "All";
        resolution = "All";
        texturePacksAdded = false;
        selectedTexturePack = 0;
        currentTexturePacks = Maps.newHashMap();
        loaded = false;
    }
}

